package models

import (
	"fmt"
	"log"
)

type Clients []Client

type Client struct {
	Id int `db:"id"`
	Ip string `db:"ip"`
}

func GetClientsIdIp(maxId int, limit int) Clients {
	var clients Clients
	err := db.Select(&clients, fmt.Sprintf("SELECT id, ip FROM clients WHERE id > $1 LIMIT %d", limit), maxId)
	if err != nil {
		log.Println(err)
	}
	return clients
}